import fetch from "node-fetch";
import fs from "fs/promises";
import path from "path";

const sitemapPath = path.join(process.cwd(), "public", "sitemap.xml");
const apiUrl = process.env.NEXT_PUBLIC_ENDPOINT;

async function generateSitemap() {
  try {
    const response = await fetch(apiUrl);
    const data = await response.text();

    await fs.writeFile(sitemapPath, data, "utf8");
  } catch (error) {
    console.error("Error generating sitemap:", error);
  }
}

generateSitemap();
