import deleteFromCart from "./deleteFromCart";
import updateQuantity from "./update-quantity";

export default async function decrementQuantityFromAPI(id, currentQuantity) {
   if (!id) {
      return { error: true, message: "Item ID is required" };
   }

   const newQuantity = Number(currentQuantity) - 1;

   if (newQuantity > 0) {
      return await updateQuantity(id, newQuantity);
   } else {
      // If quantity is 0 or less, remove the item from the cart
      return await deleteFromCart(id);
   }
}