import { getToken } from "@/actions/cookies";
import postData from "@/api/post-data";
import { getUserLocale } from "@/services/locale";

export default async function deleteFromCart(id) {
   if (!id) {
      return { error: true, message: "Item ID is required" };
   }
   const token = await getToken();
   const locale = await getUserLocale();
   const formData = new FormData();
   formData.append('item_id', id);

   return await postData({
      endPoint: '/cart/delete/item',
      body: formData,
      token,
      locale
   });

}
