"use server";
import postData from "../post-data";

export default async function updateQuantity(id, quantity = 1) {
  if (!id || quantity <= 0) {
    return { error: true, message: "Invalid item ID or quantity" };
  }

  const formData = new FormData();
  formData.append("item_id", id);
  formData.append("quantity", quantity);

  const res = await postData({
    endPoint: "/cart/update/item",
    body: formData,
  });



  if (res.error) {
    return res;
  }

  return res;
}
