import fetchData from "../fetch-data";

export default async function getCountryId(countryCode) {
   const { error, message, data } = await fetchData({ endPoint: '/countries' });
   if (error) {
      return message;
   }
   const countryId = data?.find((country) => (country.code === countryCode))?.id
   if (countryId) {
      return countryId
   }
   return null;
}