"use server";

import { getToken } from "@/actions/cookies";
import fetchData from "../fetch-data";

export default async function getUserProfile() {
  const token = await getToken();
  if (token) {
    const { data, error } = await fetchData({
      endPoint: "/user/get/profile",
    });
    if (error) {
      return null;
    }
    return data;
  }
  return null;
}
