import CustomBreadcrumb from '../ui/shared/CustomBreadcrumb'
import { Tabs, TabsContent, TabsList, TabsTrigger } from "@/components/ui/tabs"
import { useLocale, useTranslations } from 'next-intl'
import AffiliateAccount from '../ui/AffiliateAccount/AffiliateAccount';
import ChooseLink from '../ui/AffiliateAccount/ChooseLink';

export default function MarketingCurrency() {
  const locale = useLocale();
  const t = useTranslations("affiliate");


  return (
    <section >
      <CustomBreadcrumb />
      <div className="container my-6 xl:mb-10">

        <div className="bg-white p-1 lg:p-5 rounded-sm">
          <Tabs defaultValue="getlink" className="w-full" dir={locale == "en" ? "ltr" : "rtl"}>
            <TabsList className="px-0 pb-5 my-5  bg-transparent border-b-[3px] gap-4 lg:gap-10  border-[#F4F4F4] rounded-none flex duration-100 transition-all w-full justify-start">
              <TabsTrigger value="getlink" className=" px-0 text-base text-[#9DA0A1] data-[state=active]:rounded-none  pb-6 data-[state=active]:border-b-[3px] duration-100 transition-all font-extrabold data-[state=active]:border-main data-[state=active]:bg-transparent data-[state=active]:shadow-none ">{t('choose-link')}</TabsTrigger>
              <TabsTrigger value="affiliate" className=" px-0 text-base text-[#9DA0A1] data-[state=active]:rounded-none  pb-6 data-[state=active]:border-b-[3px] duration-100 transition-all font-extrabold data-[state=active]:border-main data-[state=active]:bg-transparent data-[state=active]:shadow-none ">{t('account-marketing')}</TabsTrigger>
            </TabsList>
            <TabsContent value="getlink">
              <ChooseLink />
            </TabsContent>
            <TabsContent value="affiliate">
              <AffiliateAccount />
            </TabsContent>
          </Tabs>
        </div>
      </div>
    </section>
  )
}