import { getLocale, getTranslations } from "next-intl/server";
import AgentCard from "../ui/Pigeon/AgentCard";
import CustomPagination from "../ui/Pigeon/CustomPagination";
import CustomBreadcrumb from "../ui/shared/CustomBreadcrumb";
import fetchData from "@/api/fetch-data";

export default async function Agents({ searchParams }) {
  const page = searchParams.page || 1;
  const t = await getTranslations();
  const locale = await getLocale();

  const data = await fetchData({
    endPoint: `/agents?page=${page}`,
    locale,
  });

  const lastPage = data?.meta?.last_page;
  const agents = data?.data;
  if (!agents || agents?.length === 0 || !Array.isArray(agents)) {
    return (
      <h2 className="font-bold text-2xl text-main text-center mt-16">
        {t("noAgentsYet")}
      </h2>
    );
  }

  return (
    <>
      <CustomBreadcrumb />
      <section className="container my-12">
        <div className="grid grid-cols-1 mb-8 sm:grid-cols-2 md:grid-cols-3 xl:grid-cols-4 gap-4">
          {agents?.map((agent, index) => (
            <AgentCard key={index} agent={agent} />
          ))}
        </div>
        <CustomPagination totalNumberOfPages={lastPage} />
      </section>
    </>
  );
}
