import getUserProfile from "@/api/user/getUserProfile";
import { dehydrate, HydrationBoundary } from "@tanstack/react-query";
import { Loader2 } from "lucide-react";
import { getLocale } from "next-intl/server";
import { Suspense } from "react";
import AuctionClientPage from "../ui/auctions/auction-client-page";
import { getQueryClient } from "../get-query-client";
import Loading from "../loading";
import fetchData from "@/api/fetch-data";

export default async function page({ searchParams }) {
  const queryClient = getQueryClient();
  const l = await getLocale();
  const currentPage = Number(searchParams?.page) || 1;

  // prefetch auctions
  queryClient.prefetchQuery({
    queryKey: [`/auctions?page=${currentPage}`, l], // Include page in query key for proper caching
    queryFn: () => fetchData({ endPoint: `/auctions?page=${currentPage}` }),
  });

  // prefetch user
  queryClient.prefetchQuery({
    queryKey: ["/user/get/profile"],
    queryFn: () => getUserProfile(),
  });

  return (
    <main className="container mx-auto px-4 my-10">
      <HydrationBoundary state={dehydrate(queryClient)}>
        <Suspense fallback={<Loading />}>
          <AuctionClientPage currentPage={currentPage} />
        </Suspense>
      </HydrationBoundary>
    </main>
  );
}
