import { brandsMain } from "@/api/brands";
import fetchData from "@/api/fetch-data";
import { getLocale } from "next-intl/server";
import AlertWarning from "../ui/shared/AlertWarning";
import BrandCatCardRedesignThree from "../ui/shared/BrandCatCardRedesignThree";

export default async function Page() {
  const locale = await getLocale();

  // Fetch data
  const res = await fetchData({ endPoint: "/brands", locale });
  if (res.error) {
    return <AlertWarning text={res.message} />;
  }
  const { data, message, error } = res;
  if (!(data && !error)) return <div>Loading...</div>;
  if (error) return <p>{message}</p>;

  return (
    <section>
      <div className="container grid grid-cols-2 md:grid-cols-2 xl:grid-cols-3 my-3 lg:my-8 gap-5">
        {data.map((item, index) => {
          const styleData = brandsMain[index % brandsMain.length];
          return (
            <div key={index}>
              <BrandCatCardRedesignThree
                key={item.id}
                item={item}
                styleData={styleData}
                imageClass="max-md:w-24 max-md:h-24"
                isBrand={true}
              />
            </div>
          );
        })}
      </div>
    </section>
  );
}
