import { categories } from "@/api/categories/Categories";
import fetchData from "@/api/fetch-data";
import { getLocale } from "next-intl/server";
import AlertWarning from "../ui/shared/AlertWarning";
import BrandCatCardRedesignTwo from "../ui/shared/BrandCatCardRedesignTwo";

export default async function Page() {
  const locale = getLocale();

  // Fetch data
  const res = await fetchData({ endPoint: "/categories", locale });
  if (res.error) {
    return <AlertWarning text={res.message} />;
  }

  const { data } = res;

  return (
    <section>
      <div className="container grid grid-cols-2 md:grid-cols-2 xl:grid-cols-3 gap-5 my-3 lg:my-24">
        {data.map((item, index) => {
          const styleData = categories[index % categories.length]; // Style matching for each item
          return (
            <div key={index}>
              <BrandCatCardRedesignTwo
                key={item.id}
                item={item}
                styleData={styleData}
                imageClass="max-md:w-24 max-md:h-24"
                isBrand={false}
              />
            </div>
            // <BrandCatCard
            //   key={item.id}
            //   item={item}
            //   styleData={styleData}
            //   imageClass="max-md:w-24 max-md:h-24"
            //   isBrand={false}
            // />
          );
        })}
      </div>
    </section>
  );
}
