"use client";

import { AlertTriangle } from "lucide-react";
import { useTranslations } from "next-intl";
import { useEffect } from "react";

export default function Error({ error }) {
  const t = useTranslations("notfound");
  useEffect(() => {
    // Optionally log the error to an error reporting service
    console.error(error);
  }, [error]);

  return (
    <div className="min-h-screen bg-background flex flex-col items-center justify-center p-4">
      <div className="max-w-md w-full space-y-8 text-center">
        <div className="space-y-4">
          <AlertTriangle className="mx-auto h-16 w-16 text-destructive" />
          <h2 className="text-2xl font-semibold">{t("error-wrong")}</h2>
          <p className="text-muted-foreground">{t("error-wrong-desc")}</p>
        </div>
        <div className="pt-2">
          <a
            href="/"
            className=" p-2 block w-fit px-10 m-auto border-[1px] border-dark text-dark hover:bg-dark hover:text-white duration-100 transition-all rounded-sm text-xl"
          >
            {t("go_back")}
          </a>
        </div>
      </div>
    </div>
  );
}
