import fetchData from "@/api/fetch-data";
import AlertWarning from "../ui/shared/AlertWarning";
import { getTranslations } from "next-intl/server";

export default async function ExchangeReturn() {
  const t = await getTranslations();
  let data = [];
  const response = await fetchData({
    endPoint: `/pages/33`,
  });
  if (!response.error) {
    if (response.status == "success") {
      data = response?.data;
    }
  }
  return data.length === 0 ? (
    <AlertWarning text={t("nodata")} />
  ) : (
    <div className="container my-4 space-y-4 leading-6">
      {data?.map((term, index) => (
        <div
          key={index}
          dangerouslySetInnerHTML={{ __html: term.content || "" }}
        ></div>
      ))}
    </div>
  );
}
