"use client";
import { useTranslations } from "next-intl";
import Link from "next/link";
import { GoHome } from "react-icons/go";
import FallbackImage from "./ui/shared/FallbackImage";

// BY MOHAMMED HOSSAM
// DATE 21-10-2024
// NOT FOUND PAGE
export default function NotFound() {
  const t = useTranslations("notfound"); // Hook for translations

  return (
    <section>
      <div className="container my-10 2xl:my-20 flex items-center justify-center flex-col  xl:mb-20 space-y-5">
        <FallbackImage
          src="/error/404_540x.png"
          width={500}
          height={500}
          alt="error illustration"
        />
        <h1 className="font-lightbold text-4xl">
          <span className="text-main">{t("error_title")}</span>{" "}
          {t("error_message")}
        </h1>
        <p className="text-[#5F6C72] text-xl">{t("error_description")}</p>
        <div className="flex gap-x-3">
          <Link
            href="/"
            className="btn-main rounded-full gap-x-3 flex items-center text-white  text-xl py-4 px-8 hover:bg-secondary  hover:border-transparent  hover:text-white transition-all duration-300"
          >
            {t("return_home")}
            <GoHome />
          </Link>
        </div>
      </div>
      {/* <div className="container my-10 2xl:my-20 flex items-center justify-center flex-col bg-[#FAFBFC] xl:mb-20 space-y-5">
                <FallbackImage src="/error/404.png" width={300} height={300} alt="error illustration" />
                <h1 className="font-lightbold text-4xl">
                    <span className="text-main">{t('error_title')}</span> {t('error_message')}
                </h1>
                <p className="text-[#5F6C72] text-xl">{t('error_description')}</p>
                <div className="flex gap-x-3">
                    <Link href="/" className="btn-main gap-x-3 flex items-center text-white rounded-sm text-xl p-2">
                        {t('return_home')}
                        <GoHome />
                    </Link>
                    <button onClick={handleRemoveLastPath} className="btn-main-outline gap-x-3 flex items-center rounded-sm text-xl p-2">
                        <BsArrowRight />
                        {t('go_back')}
                    </button>
                </div>
            </div> */}
    </section>
  );
}
