import fetchData from "@/api/fetch-data";
import { getLocale, getTranslations } from "next-intl/server";
import Link from "next/link";
import AlertWarning from "../ui/shared/AlertWarning";
import FallbackImage from "../ui/shared/FallbackImage";
import CustomBreadcrumb from "../ui/shared/CustomBreadcrumb";

export default async function Page() {
  const o = await getTranslations("offers");
  const locale = await getLocale();
  let offers = [];
  const response = await fetchData({ endPoint: "/offers", locale });
  if (!response?.error) {
    if (response?.status == "success") {
      offers = response?.data?.offers_category;
    }
  }
  return (
    <>
      <CustomBreadcrumb />
      <div className="container my-6">
        <div className="grid grid-cols-12 gap-6">
          {offers.length > 0 ?
            offers?.map((item, index) => (
              <div key={index} className="3xl:col-span-3 md:col-span-4 col-span-12">
                <Link href={`/offers/category/${item?.id}`} className="block bg-white md:p-4 p-8 space-y-4 hover:shadow-lg hover:scale-[1.02] transition-all duration-300">
                  {/* image */}
                  <div className="relative h-52">
                    <FallbackImage
                      src={item?.image}
                      alt={item?.title||"product image"}
                      fill
                      className="object-cover"
                    />
                  </div>
                  <h2 className="text-center font-semibold text-2xl">{item?.title}</h2>
                </Link>
              </div>
            )) :
            <div className="col-span-12">
              <AlertWarning text={o("noOffers")} />
            </div>
          }
        </div>
      </div></>
  );
}