"use client";
import { useSearchParams } from "next/navigation";
import Link from "next/link";
import { IoCloseCircle } from "react-icons/io5";
import { GoHome } from "react-icons/go";
import { useLocale, useTranslations } from "next-intl";
import { getToken } from "@/actions/cookies";
import fetchData from "@/api/fetch-data";
import { useEffect } from "react";
import useCart from "@/stores/cart";

export default function Page() {
  const t = useTranslations("payment");
  const searchParams = useSearchParams();
  const invoiceId = searchParams.get("invoice_id");
  const locale = useLocale();
  const paymentId = searchParams.get("paymentId");
  const Id = searchParams.get("Id");

  const { updateCart } = useCart();

  async function confirm() {
    const payment_method = localStorage.getItem("payment_method");
    const response = await fetchData({
      endPoint: `/payment/failed?payment_method=${payment_method}&invoice_id=${invoiceId}&is_fawaterk=1`,
      locale,
    });

    if (!response.error) {
      if (response?.status == "success") {
        localStorage.removeItem("payment_method");
        localStorage.removeItem("orderId");
        updateCart();
      }
    }
  }
  useEffect(() => {
    confirm();
  }, []);
  return (
    <section>
      <div className="container  flex items-center justify-center  flex-col bg-[#FAFBFC] pb-10  h-[80vh] space-y-5 ">
        <IoCloseCircle
          size={50}
          className="text-red-500 text-2xl md:text-4xl"
        />
        <h1 className="font-bold text-2xl md:text-4xl">{t("failure.title")}</h1>
        <Link href="/">
          <button className="btn btn-main-outline gap-x-2 flex items-center rounded-sm md:text-xl ">
            <GoHome />
            {t("failure.button")}
          </button>
        </Link>
      </div>
    </section>
  );
}
