import fetchData from "@/api/fetch-data";
import ProductsCartDetails from "@/app/ui/checkout-info/ProductsCartDetails";
import CustomBreadcrumb from "@/app/ui/shared/CustomBreadcrumb";
import PaymentMethods from "../ui/checkout-info/PaymentMethods";
import AlertWarning from "../ui/shared/AlertWarning";

export default async function CheckoutInfo() {
  let payments = [];
  // fetch payment methods
  const [paymentResponse, cartResponse] = await Promise.all([
    fetchData({ endPoint: "/cart/payment_methods" }),
    fetchData({ endPoint: "/cart/items" }),
  ]);

  if (paymentResponse?.status === "success") {
    payments = paymentResponse?.data;
  }

  return (
    <>
      <CustomBreadcrumb />
      {cartResponse.data?.products ? (
        <main className="flex flex-col gap-4 lg:gap-8 w-full md:flex-row mb-12 md:mb-16">
          <ProductsCartDetails response={cartResponse} />
          <div className="px-4 md:px-6 lg:px-8 space-y-8 mt-8 lg:w-1/2 w-full">
            <PaymentMethods payments={payments} />
          </div>
        </main>
      ) : (
        <AlertWarning text={cartResponse.message} />
      )}
    </>
  );
}
