import fetchData from "@/api/fetch-data";
import { getLocale } from "next-intl/server";
import AlertWarning from "../ui/shared/AlertWarning";

export default async function Page() {
  const locale = await getLocale();
  let data = [];
  const response = await fetchData({
    endPoint: `/pages/32`,
    locale
  })
  if (!response.error) {
    if (response.status == "success") {
      data = response?.data;
    }
  }
  return (

    data.length === 0 ?
      <AlertWarning text="لاتوجد بيانات حاليا" />
      :
      <div div className="container my-6 sapce-y-6 leading-7 " >
        {data?.map((term, index) =>
          <div key={index} dangerouslySetInnerHTML={{ __html: term.content || "" }} ></div>
        )
        }
      </div >
  );
}