"use client";
import { useLocale, useTranslations } from "next-intl";
import { useEffect, useState } from "react";
import fetchData from "@/api/fetch-data";
import { getToken } from "@/actions/cookies";
import AllAffiliate from "./AllAffiliate";
import Loading from "../shared/Loading";
import AlertWarning from "../shared/AlertWarning";

export default function AffiliateAccount() {
  const locale = useLocale();
  const t = useTranslations("affiliate");
  const e = useTranslations();
  const [affiliateData, setAffiliateData] = useState([]);
  const [isAffiliateLoading, setIsAffiliateLoading] = useState(false);
  const [isAffiliateError, setIsAffiliateError] = useState(null);
  const [currentPage, setCurrentPage] = useState(1); // Current page
  const [totalPages, setTotalPages] = useState(1); // Total pages

  async function getAffiliateData(page = 1) {
    setIsAffiliateLoading(true);
    const res = await fetchData({
      endPoint: `/user/products/affiliate?page=${page}`,
      locale,
    });
    const { data, error, message } = res;
    if (error) {
      setIsAffiliateLoading(false);
      setIsAffiliateError(message);
    } else {
      setIsAffiliateLoading(false);
      setAffiliateData(data);
      setTotalPages(data.pagination.last_page || 1); // Set total pages from API response
    }
  }

  useEffect(() => {
    getAffiliateData(currentPage); // Fetch data for the current page
  }, [currentPage]);

  const handlePageChange = (page) => {
    if (page > 0 && page <= totalPages) {
      setCurrentPage(page);
    }
  };

  if (isAffiliateLoading) return <Loading />;
  if (isAffiliateError) return <AlertWarning text={t("error")} />;
  // if (affiliateData.length == 0) return <AlertWarning text={e("nodata")} />;

  return (
    <div className="">
      {/* Affiliate Stats */}
      <div className="flex justify-start xl:my-10 ">
        <div className="px-0 max-md:mt-6 bg-transparent rounded-none flex gap-2 lg:gap-10 w-fit justify-start">
          <div className="px-0 text-sm lg:text-base text-[#9DA0A1]">
            {t("click-count")} ({affiliateData?.click_count || 0})
          </div>
          <div className="px-0 text-sm lg:text-base text-[#9DA0A1]">
            {t("waiting-orders")} ({affiliateData?.order_pending_count || 0})
          </div>
          <div className="px-0 text-sm lg:text-base text-[#9DA0A1]">
            {t("confirmed-orders")} ({affiliateData?.order_complete_count || 0})
          </div>
          <div className="px-0 text-sm lg:text-base text-[#9DA0A1]">
            {t("waiting-elements")} ({affiliateData?.item_pending_count || 0})
          </div>
          <div className="px-0 text-sm lg:text-base text-[#9DA0A1]">
            {t("confirmed-elements")} ({affiliateData?.item_complete_count || 0}
            )
          </div>
        </div>
      </div>

      {/* Affiliate Table */}
      <div className="mt-6">
        <AllAffiliate data={affiliateData} loading={isAffiliateLoading} />
      </div>

      {/* Pagination Controls */}
      <div className="flex justify-center mt-4">
        <button
          onClick={() => handlePageChange(currentPage - 1)}
          className="px-4 py-2 border rounded-md"
          disabled={currentPage == 1}
        >
          {t("prev")}
        </button>
        <span className="mx-4  flex items-center">
          {t("page")} {currentPage} {t("of")} {totalPages}
        </span>
        <button
          onClick={() => handlePageChange(currentPage + 1)}
          className="px-4 py-2 border rounded-md"
          disabled={currentPage == totalPages}
        >
          {t("next")}
        </button>
      </div>
    </div>
  );
}
