import {
    Table,
    TableBody,
    TableCell,
    TableHead,
    TableHeader,
    TableRow,
} from "@/components/ui/table";
import Loading from "../shared/Loading";
import { useTranslations } from "next-intl";
export default function AllAffiliate({ data, loading }) {
    const t = useTranslations("affiliate");

    return <div className="xl:mb-10 overflow-x-auto">
        <Table className="min-w-full overflow-x-auto">
            <TableHeader className="bg-light py-4 md:py-6 text-white">
                <TableRow className="font-extrabold">
                    <TableHead className="font-bold max-md:text-sm text-base md:text-xl text-center text-black">
                        {t("id")}
                    </TableHead>
                    <TableHead className="font-bold max-md:text-sm text-base md:text-xl text-center text-black">
                        {t("name")}
                    </TableHead>
                    <TableHead className="font-bold max-md:text-sm text-base md:text-xl text-center text-black">
                        {t("code")}
                    </TableHead>
                    <TableHead className="font-bold max-md:text-sm text-base md:text-xl text-center text-black">
                        {t("visits")}
                    </TableHead>
                    <TableHead className="font-bold max-md:text-sm text-base md:text-xl text-center text-black">
                        {t("sales")}
                    </TableHead>
                </TableRow>
            </TableHeader>
            {!loading ? <TableBody className="">
                {data?.products?.map((item, index) => (
                    <TableRow key={index} className="text-base  md:text-lg lg:shadow-lg">
                        <TableCell className="lg:tracking-[.25em]  py-2 md:py-4   text-center">
                            <h4>{item.product_id}</h4>
                        </TableCell>
                        <TableCell className="py-2 md:py-4 text-center max-md:text-sm" >
                            <span className=" mx-2 text-md">{item.title}</span>
                        </TableCell>

                        <TableCell className="py-2 md:py-4 text-center max-md:text-sm" >
                            <span className=" mx-2">{item.code}</span>
                        </TableCell>


                        <TableCell className="lg:tracking-[.25em] py-2 md:py-4   text-center">
                            <h4>{item.visitsCount}</h4>
                        </TableCell>
                        <TableCell className=" md:py-4 text-center max-md:text-sm" >
                            <span className=" mx-2">{item.sales}</span>
                        </TableCell>


                    </TableRow>
                ))}
            </TableBody> : <div className="flex items-center my-10">
                <Loading />
            </div>
            }
        </Table>
    </div>
}
