"use client";
import { Button } from "@/components/ui/button";
import { toastError, toastSuccess } from "@/services/custom-toast";
import { useTranslations } from "next-intl";

export default function LinkButton({ text, link }) {
  const t = useTranslations("affiliate");
  return (
    <Button
      className="bg-main hover:bg-main/90"
      onClick={() => {
        if (link) {
          navigator.clipboard.writeText(link);
          toastSuccess(t("success"));
          return;
        }
        toastError(t("error"));
      }}
    >
      {text}
    </Button>
  );
}
