import { Separator } from "@/components/ui/separator";
import Image from "next/image";
import PhoneIcon from "./Icons/PhoneIcon";
import MailIcon from "./Icons/MailIcon";
import HomeIcon from "./Icons/HomeIcon";
export default function AgentCard({ agent }) {
  return (
    <div className="relative overflow-hidden transition-all duration-300 ease-in-out bg-white group rounded-[6px] shadow p-3 lg:p-6 mb-10">
      <div className="scale-0 group-hover:scale-100 bg-main rounded-lg transition-transform duration-500 ease-out absolute inset-0 origin-center" />
      <div className="relative z-10 group-hover:text-white transition-colors duration-300">
        <div className="1-translate-y-14 group-hover:translate-y-0 duration-500 transition-transform flex flex-col items-center space-y-4">
          <div className="bg-main rounded-md inline-block">
            <Image
              unoptimized
              width={500}
              height={500}
              className="size-20 object-contain"
              src={agent.image || "/pigeon/auction-card.png"}
              alt={agent.name || "agent card"}
            />
          </div>
          <p className="text-center font-bold text-xl">{agent.name}</p>
        </div>
        <Separator className="my-4" />
        <div className="flex flex-wrap items-center gap-2">
          <div className="flex gap-1 items-center">
            <PhoneIcon className="group-hover:fill-white transition-colors duration-300" />
            <p className="text-sm line-clamp-1">{agent.phone}</p>
          </div>
          <div className="flex items-center gap-1">
            <MailIcon className="group-hover:fill-white transition-colors duration-300" />
            <p className="text-sm line-clamp-1 break-words">{agent.email}</p>
          </div>
          <div className="flex items-center gap-1">
            <HomeIcon className="group-hover:fill-white transition-colors duration-300" />
            <p className="text-sm line-clamp-1">{agent.address}</p>
          </div>
        </div>
      </div>
    </div>
  );
}
