'use client'
import BlackBtn from '@/app/ui/shared/BlackBtn'
import { Select, SelectContent, SelectGroup, SelectItem, SelectTrigger, SelectValue } from "@/components/ui/select"
import {
    Table,
    TableBody,
    TableCell,
    TableHead,
    TableHeader,
    TableRow
} from "@/components/ui/table"
import { useState } from 'react'

import PopUpForm from '@/app/ui/shared/PopUpForm'
import Link from 'next/link'
import { BsArrowRight } from 'react-icons/bs'
import { CiCalendar } from 'react-icons/ci'
import { IoClose } from "react-icons/io5"

export default function Page() {
    const data = [
        {
            id: "1",
            date: "Aug 14, 2024-10:42 pm",
            price: "777.00",
            type: "نفاصيل المنتج",
            desc: "SKU#8675309JNY",
            transactionId: "1"
        },
        {
            id: "2",
            date: "Aug 15, 2024-11:30 am",
            price: "500.00",
            type: "نفاصيل المنتج",
            desc: "SKU#8675309JNY",
            transactionId: "1"
        },
        // Add more data as needed
    ];

    const [showModal, setShowModal] = useState(false);

    const modelForm = (
        <form className='space-y-4 p-6 '>
            {/*START OBJECT INPUT */}
            <div className="mb-4">
                <input
                    type="text"
                    className="btn-outline-black"
                    placeholder="المبلغ..."
                />
            </div>
            {/*END OBJECT INPUT */}
            <Select className="btn-outline-black border-black" dir='rtl'>
                <SelectTrigger className="h-8 md:h-10 lg:h-12 btn-outline-black border-black focus:ring-main">
                    <SelectValue className="placeholder:text-secondary btn-outline-black" placeholder="فيزا" />
                </SelectTrigger>
                <SelectContent>
                    <SelectGroup>
                        <SelectItem value='a'>فيزا</SelectItem>
                    </SelectGroup>
                </SelectContent>
            </Select>
            <div className="mb-4">
                <textarea
                    className="btn-outline-black"
                    rows="4"
                    placeholder="التفاصيل..."
                ></textarea>
            </div>
            <div className="flex justify-start">
                <button
                    type="button"
                    className="text-black absolute top-5 left-5 text-xl hover:text-red-400 rounded"
                    onClick={() => setShowModal(false)}
                >
                    <IoClose />
                </button>
                <Link href='/' className='btn-main gap-x-1 flex m-auto items-center text-white rounded-sm text-sm p-2'>
                    <BsArrowRight />
                    إرسال طلب
                </Link>
            </div>
        </form>
    );

    return (
        <section>
            <div>
                <div className="flex flex-wrap gap-2 xl:gap-10 justify-center">
                    {/* FIRST  */}
                    <div className="bg-white  max-xl:w-[45%] py-7 rounded-sm lg:px-10 xl:px-20">
                        <div className="flex flex-col items-center gap-2 justify-center">
                            <h4 className='font-bold text-2xl'>30</h4>
                            <h4>نقطه</h4>
                        </div>
                    </div>
                    {/* Second */}
                    <div className="bg-[#EBF9FF]  max-xl:w-[45%] py-7 rounded-sm lg:px-10 xl:px-20">
                        <div className="flex flex-col items-center gap-2 justify-center">
                            <h4 className='font-bold text-2xl'>880 <span className='font-light'>ج.م</span></h4>
                            <h4>الرصيد</h4>
                        </div>
                    </div>
                    <BlackBtn onclick={() => setShowModal(true)} title={'شحن رصيدي'} className={'self-end'} />
                </div>

                <div className="my-10 overflow-x-auto">
                    <Table className="">
                        <TableHeader className="bg-light py-4 md:py-6 text-white">
                            <TableRow className="font-extrabold">
                                <TableHead className="font-extrabold text-base md:text-xl text-center text-black">#</TableHead>
                                <TableHead className="font-extrabold text-base md:text-xl text-center max-md:hidden text-black">التاريخ</TableHead>
                                <TableHead className="font-extrabold text-base md:text-xl text-center text-black">المبلغ</TableHead>
                                <TableHead className="font-extrabold text-base md:text-xl text-center text-black">النوع</TableHead>
                                <TableHead className="font-extrabold text-base md:text-xl text-center text-black">الحالة</TableHead>
                            </TableRow>
                        </TableHeader>
                        <TableBody className="cursor-pointer">
                            {data.map((invoice) => (
                                <TableRow key={invoice.id} className="text-base md:text-lg shadow-md">
                                    <TableCell className="py-2 md:py-4 text-center">
                                        {invoice.transactionId}
                                    </TableCell>
                                    <TableCell className="py-2 md:py-4 text-center justify-center h-[50px] lg:h-[100px] gap-2 flex items-center max-md:hidden">
                                        <div ><CiCalendar /></div>
                                        <h4>{invoice.date}</h4>
                                    </TableCell>
                                    <TableCell className="py-2 md:py-4 text-center">
                                        <span>ج.م</span>
                                        <span className="font-extrabold mx-2">
                                            {invoice.price}
                                        </span>
                                    </TableCell>
                                    <TableCell className="py-2 md:py-4 text-center">
                                        <button className="bg-black p-1 md:p-2 rounded-sm text-sm md:text-md text-white">
                                            دفع كاش
                                        </button>
                                    </TableCell>
                                    <TableCell className="py-2 md:py-4 text-center">
                                        <h4 className="bg-[#FFFCE7] w-fit px-2 py-1 text-sm md:text-md">
                                            في الانتظار
                                        </h4>
                                    </TableCell>
                                </TableRow>
                            ))}
                        </TableBody>
                    </Table>
                </div>
                {showModal && (
                    <PopUpForm title={'شحن رصيدي'} form={modelForm} />
                )}
            </div>
        </section>
    );
}
