'use client';
import Link from "next/link";
import AlertWarning from "../../shared/AlertWarning";
import { Table, TableBody, TableCell, TableHead, TableHeader, TableRow } from "@/components/ui/table";
import { useTranslations } from "next-intl";

export default function TicketsUi({ ticketsData }) {
    const { error, data, message } = ticketsData;
    const t = useTranslations('user');

    if (error) return <AlertWarning text={message} />;

    return (
        <>
            {
                data?.length > 0 ? (
                    <div className="xl:my-10 overflow-x-auto">
                        <Table className="min-w-full">
                            <TableHeader className="bg-light py-4 md:py-6 text-white">
                                <TableRow className="font-extrabold">
                                    <TableHead className="font-extrabold text-base md:text-xl text-center text-black">#</TableHead>
                                    <TableHead className="font-extrabold text-base md:text-xl text-center text-black">{t('subject')}</TableHead>
                                    <TableHead className="font-extrabold text-base md:text-xl text-center text-black">{t('control')}</TableHead>
                                    <TableHead className="font-extrabold text-base md:text-xl text-center text-black">{t('status')}</TableHead>
                                </TableRow>
                            </TableHeader>
                            <TableBody className="">
                                {data.map((item, index) => (
                                    <TableRow key={index} className="text-base md:text-lg lg:shadow">
                                        <TableCell className="lg:tracking-[.25em] py-2 md:py-4 font-extrabold text-center">
                                            <h4>{index + 1}</h4>
                                        </TableCell>
                                        <TableCell className="py-2 md:py-4 text-center">
                                            <span className="font-extrabold mx-2">{item.subject}</span>
                                            <p className="mx-2">{item.contents}</p>
                                        </TableCell>
                                        <TableCell className="py-2 md:py-4 text-center">
                                            <Link href={`/user/my-tickets/${item.id}`} className="bg-black p-1 md:p-2 rounded-sm text-sm hover:bg-main duration-100 transition-all md:text-md text-white">
                                                {t('watch')}
                                            </Link>
                                        </TableCell>
                                        <TableCell className="py-2 md:py-4 text-center">
                                            {item.desc == 1 ? (
                                                <h4 className="bg-[#E7FFEC] m-auto w-fit px-3 py-2 text-md md:text-md rounded-sm">{item.status}</h4>
                                            ) : item.desc == 2 ? (
                                                <h4 className="bg-[#FFE5E8] m-auto w-fit px-3 py-2 text-md md:text-md rounded-sm">{item.status}</h4>
                                            ) : (
                                                <h4 className="bg-[#D1F1FF] m-auto w-fit px-3 py-2 text-md md:text-md rounded-sm">{item.status}</h4>
                                            )}
                                        </TableCell>
                                    </TableRow>
                                ))}
                            </TableBody>
                        </Table>
                    </div>
                ) : (
                    <AlertWarning text={t('noTicketsMessage')} />
                )
            }
        </>
    );
}
