"use client";
import logout from "@/api/user/logout";
import { Button } from "@/components/ui/button";
import {
  Dialog,
  DialogClose,
  DialogContent,
  DialogDescription,
  DialogFooter,
  DialogHeader,
  DialogTitle,
} from "@/components/ui/dialog";
import { toastError, toastSuccess } from "@/services/custom-toast";
import { Loader2 } from "lucide-react";
import { useTranslations } from "next-intl";
import Link from "next/link";
import { usePathname } from "next/navigation"; // Import usePathname
import { useState, useTransition } from "react";
import { BsTicketPerforated } from "react-icons/bs";
import { CiBellOn } from "react-icons/ci";
import { HiOutlineChatBubbleBottomCenterText } from "react-icons/hi2";
import { RiUserLine } from "react-icons/ri";
import { TbLogout2 } from "react-icons/tb";
import { TiCreditCard } from "react-icons/ti";

export default function MobileTap() {
  const pathname = usePathname(); // Get the current path
  const [isPending, startTransition] = useTransition();
  const t = useTranslations("user");
  const s = useTranslations("shared");
  const isActive = (href) => pathname === href; // Compare the current path with the link href
  // STATE FOR SHOWING THE MODEL OR HIDING
  const [showModal, setShowModal] = useState(false);
  const pathName = usePathname().includes("/my-tickets");

  return (
    <section className=" bg-white rounded-b-lg   relative   inset-x-0">
      <div className="text-sm   font-medium text-center text-gray-500  ">
        <ul className="flex   p-4 flex-wrap items-center md:py-10 max-lg:justify-center lg:justify-between">
          {/*MY PROFILE  */}
          <li className=" hover:bg-gray-100 gap-2  flex items-center rounded-md p-2  ">
            <RiUserLine />
            <Link
              href="/user"
              className={`flex items-center justify-start gap-8 group text-sm ${isActive(`/user`) ? "font-bold  text-main " : "text-[#484848]"
                } duration-150 transition-all`}
            >
              <div className="flex items-center justify-center gap-4">
                <h2 className="group-hover:text-main duration-150 text-md transition-all">
                  {t("myprofile")}
                </h2>
              </div>
            </Link>
          </li>

          {/*  MY ORDERS*/}
          <li className=" hover:bg-gray-100 gap-2  flex items-center rounded-md p-2  ">
            <HiOutlineChatBubbleBottomCenterText />
            <Link
              href="/user/my-orders"
              className={`flex items-center justify-start gap-8 group text-sm ${isActive(`/user/my-orders`)
                ? "font-bold  text-main "
                : "text-[#484848]"
                } duration-150 transition-all`}
            >
              <div className="flex items-center justify-center gap-4">
                <h2 className="group-hover:text-main duration-150 text-md transition-all">
                  {t("myorders")}
                </h2>
              </div>
            </Link>
          </li>
          {/*  MY CEDIT*/}
          <li className=" hover:bg-gray-100 gap-2  flex items-center rounded-md p-2  ">
            <TiCreditCard />
            <Link
              href="/user/my-credit"
              className={`flex items-center justify-start gap-8 group text-sm ${isActive(`/user/my-credit`)
                ? "font-bold  text-main "
                : "text-[#484848]"
                } duration-150 transition-all`}
            >
              <div className="flex items-center justify-center gap-4">
                <h2 className="group-hover:text-main duration-150 text-md transition-all">
                  {t("mycredit")}
                </h2>
              </div>
            </Link>
          </li>
          {/*  MY tickets*/}
          <li className=" hover:bg-gray-100 gap-2  flex items-center rounded-md p-2  ">
            <BsTicketPerforated />
            <Link
              href="/user/my-tickets"
              className={`flex items-center justify-start gap-8 group text-sm 
                ${isActive(`/user/my-tickets`) || pathName
                  ? "font-bold  text-main "
                  : "text-[#484848]"
                } duration-150 transition-all`}
            >
              <div className="flex items-center justify-center gap-4">
                <h2 className="group-hover:text-main duration-150 text-md transition-all">
                  {t("tickets")}
                </h2>
              </div>
            </Link>
          </li>
          {/*  MY Natofications*/}
          <li className=" hover:bg-gray-100 gap-2   flex items-center rounded-md p-2  ">
            <CiBellOn className="text-lg" />
            <Link
              href="/user/natofications"
              className={`flex items-center justify-start gap-8 group text-sm ${isActive(`/user/natofications`)
                ? "font-bold  text-main "
                : "text-[#484848]"
                } duration-150 transition-all`}
            >
              <div className="flex items-center justify-center gap-4">
                <h2 className="group-hover:text-main duration-150 text-md transition-all">
                  {t("natofications")}
                </h2>
              </div>
            </Link>
          </li>
          {/*  log out*/}
          <li
            onClick={() => setShowModal(true)}
            className=" p-2 flex items-center  hover:bg-gray-100 gap-2 rounded-md"
          >
            <TbLogout2 />
            <button
              className={`flex items-center justify-start gap-8 m-auto group text-sm ${isActive(`/user/my-reserations`)
                ? "font-bold  text-main "
                : "text-[#484848]"
                } duration-150 transition-all`}
            >
              <div className="flex items-center justify-center gap-4">
                <h2 className="group-hover:text-main duration-150 text-md transition-all">
                  {t("logout")}
                </h2>
              </div>
            </button>
          </li>
        </ul>
      </div>

      <Dialog open={showModal} onOpenChange={setShowModal}>
        <DialogContent className="w-fit sm:max-w-md">
          <DialogHeader>
            <DialogTitle>{s("logout")}</DialogTitle>
          </DialogHeader>
          <DialogDescription className="text-sm text-gray-950 lg:text-xl text-center font-bold">
            {s("logout-alert")}
          </DialogDescription>
          <DialogFooter className="flex flex-row justify-center mx-auto items-center gap-6">
            <Button
              className="w-32"
              type="button"
              onClick={() => {
                startTransition(async () => {
                  const { error, message } = await logout();
                  if (error) {
                    toastError(message);
                  } else {
                    toastSuccess(message);
                    localStorage.removeItem("wishlist-storage");
                    setShowModal(false);
                    location.href = "/";
                  }
                });
              }}
            >
              {isPending ? <Loader2 className="animate-spin" /> : s("yes")}
            </Button>
            <DialogClose asChild>
              <Button className="w-32" type="button" variant="secondary">
                {s("no")}
              </Button>
            </DialogClose>
          </DialogFooter>
        </DialogContent>
      </Dialog>
    </section>
  );
}
