"use client";
import { usePathname } from "next/navigation"; // Import usePathname
import { useTranslations } from "next-intl";
import { HiOutlineChatBubbleBottomCenterText } from "react-icons/hi2";
import Link from "next/link";
import React, { useEffect, useState, useTransition } from "react";
import { TiCreditCard } from "react-icons/ti";
import { RiUserLine } from "react-icons/ri";
import { BsTicketPerforated } from "react-icons/bs";
import { TbAffiliate, TbLogout2, TbShoppingBag } from "react-icons/tb";
import { CiBellOn } from "react-icons/ci";
import { IoStatsChartOutline } from "react-icons/io5";
import { Avatar, AvatarFallback, AvatarImage } from "@/components/ui/avatar";
import {
  Dialog,
  DialogClose,
  DialogContent,
  DialogDescription,
  DialogFooter,
  DialogHeader,
  DialogTitle,
} from "@/components/ui/dialog";
import { Button } from "@/components/ui/button";
import { Loader2 } from "lucide-react";
import logout from "@/api/user/logout";
import { toastError, toastSuccess } from "@/services/custom-toast";
import { PiMoneyWavyThin } from "react-icons/pi";
import { getVendor } from "@/actions/cookies";
export default function Tap({ user }) {
  // STATE FOR SHOWING THE MODAL OR HIDING
  const [showModal, setShowModal] = useState(false);
  const pathname = usePathname(); // Get the current path
  const isActive = (href) => pathname === href; // Compare the current path with the link href
  const t = useTranslations("user");
  const s = useTranslations("shared");
  const [isPending, startTransition] = useTransition();
  const pathName = usePathname().includes("/my-tickets");
  const isActiveVendor =
    user?.is_vendor == "1" && user?.is_vendor_active == "1";
  return (
    <section className="h-full bg-white">
      <div className="p-5 space-y-7 flex flex-col items-center justify-center">
        {/* PROFILE */}
        <div className="profile flex items-center justify-start flex-col gap-4">
          <Avatar className="mx-auto mb-4 border-main border-2  size-28 md:size-36">
            <AvatarImage src={user?.image} />
            <AvatarFallback className="text-3xl md:text-5xl text-main">
              {user?.name?.slice(0, 2)?.toUpperCase()}
            </AvatarFallback>
          </Avatar>
          <div className="flex items-center justify-start flex-col ">
            <h3 className=" text-xl">
              {" "}
              {t("hello")},<span className="font-extrabold">{user?.name}</span>
            </h3>
            <p
              className="text-[#999999] w-[90%] overflow-hidden text-ellipsis whitespace-nowrap"
              dir="ltr"
            >
              {user?.email}
            </p>
          </div>
        </div>
        <ul className="flex flex-col items-center gap-y-6 justify-center">
          {/* MY PROFILE */}
          <li className="w-full">
            <Link
              href="/user"
              className={`link-item flex items-center justify-start gap-8 group text-lg ${isActive(`/user`) ? "active" : "text-[#484848]"
                } duration-150 transition-all`}
            >
              <div className="flex items-center justify-center gap-4">
                <RiUserLine />
                <h2 className="group-hover:text-main duration-150 transition-all">
                  {t("myprofile")}
                </h2>
              </div>
            </Link>
          </li>
          {isActiveVendor && (
            <>
              {/* My Product */}
              <li className="w-full">
                <Link
                  href={`/vendor`}
                  className={`link-item flex items-center justify-start gap-8 group text-lg ${isActive(`/user/vindor`) ? "active" : "text-[#484848]"
                    } duration-150 transition-all`}
                >
                  <div className="flex items-center justify-center gap-4">
                    <TbShoppingBag />
                    <h2 className="group-hover:text-main duration-150 transition-all">
                      {t("my-products")}
                    </h2>
                  </div>
                </Link>
              </li>
              {/* withdrawing */}
              <li className="w-full">
                <Link
                  href="/user/withdrawing"
                  className={`link-item flex items-center justify-start gap-8 group text-lg ${isActive(`/user/withdrawing`) ? "active" : "text-[#484848]"
                    } duration-150 transition-all`}
                >
                  <div className="flex items-center justify-center gap-4">
                    <PiMoneyWavyThin />
                    <h2 className="group-hover:text-main duration-150 transition-all">
                      {t("my-withdrawing")}
                    </h2>
                  </div>
                </Link>
              </li>
              {/* REPORT */}
              <li className="w-full">
                <Link
                  href="/user/reports"
                  className={`link-item flex items-center justify-start gap-8 group text-lg ${isActive(`/user/reports`) ? "active" : "text-[#484848]"
                    } duration-150 transition-all`}
                >
                  <div className="flex items-center justify-center gap-4">
                    <IoStatsChartOutline />
                    <h2 className="group-hover:text-main duration-150 transition-all">
                      {t("reports")}
                    </h2>
                  </div>
                </Link>
              </li>
            </>
          )}

          {/* MY ORDERS */}
          <li className="w-full">
            <Link
              href="/user/my-orders"
              className={`link-item flex items-center justify-start gap-8 group text-lg ${isActive(`/user/my-orders`) ? "active" : "text-[#484848]"
                } duration-150 transition-all`}
            >
              <div className="flex items-center justify-center gap-4">
                <HiOutlineChatBubbleBottomCenterText />
                <h2 className="group-hover:text-main duration-150 transition-all">
                  {t("myorders")}
                </h2>
              </div>
            </Link>
          </li>
          {user?.is_affiliate == true && (
            <li className="w-full">
              <Link
                href="/affiliate"
                className={`link-item flex items-center justify-start gap-8 group text-lg ${isActive(`/affiliate`) ? "active" : "text-[#484848]"
                  } duration-150 transition-all`}
              >
                <div className="flex items-center justify-center gap-4">
                  <TbAffiliate />
                  <h2 className="group-hover:text-main duration-150 transition-all">
                    {t("affiliate")}
                  </h2>
                </div>
              </Link>
            </li>
          )}
          {/* MY CREDIT */}
          <li className="w-full">
            <Link
              href="/user/my-credit"
              className={`link-item flex items-center justify-start gap-8 group text-lg ${isActive(`/user/my-credit`) ? "active" : "text-[#484848]"
                } duration-150 transition-all`}
            >
              <div className="flex items-center justify-center gap-4">
                <TiCreditCard />
                <h2 className="group-hover:text-main duration-150 transition-all">
                  {t("mycredit")}
                </h2>
              </div>
            </Link>
          </li>
          {/* MY TICKETS */}
          <li className="w-full">
            <Link
              href="/user/my-tickets"
              className={`link-item flex items-center justify-start gap-8 group text-lg ${isActive(`/user/my-tickets`) || pathName
                ? "active"
                : "text-[#484848]"
                } duration-150 transition-all`}
            >
              <div className="flex items-center justify-center gap-4">
                <BsTicketPerforated />
                <h2 className="group-hover:text-main duration-150 transition-all">
                  {t("tickets")}
                </h2>
              </div>
            </Link>
          </li>
          {/* MY NOTIFICATIONS */}
          <li className="w-full">
            <Link
              href="/user/natofications"
              className={`link-item flex items-center justify-start gap-8 group text-lg ${isActive(`/user/natofications`) ? "active" : "text-[#484848]"
                } duration-150 transition-all`}
            >
              <div className="flex items-center justify-center gap-4">
                <CiBellOn />
                <h2 className="group-hover:text-main duration-150 transition-all">
                  {t("natofications")}
                </h2>
              </div>
            </Link>
          </li>
          {/* LOG OUT */}
          <li
            onClick={() => setShowModal(true)}
            className="w-full cursor-pointer"
          >
            <div
              className={`link-item flex items-center justify-start gap-8 m-auto group text-lg ${isActive(`/user/my-reserations`) ? "active" : "text-[#484848]"
                } duration-150 transition-all`}
            >
              <div className="flex items-center justify-start gap-4">
                <TbLogout2 />
                <h2 className="group-hover:text-main duration-150 transition-all">
                  {t("logout")}
                </h2>
              </div>
            </div>
          </li>
        </ul>
      </div>
      {/* Logout Dialog */}
      <Dialog open={showModal} onOpenChange={setShowModal}>
        <DialogContent className="w-fit sm:max-w-md overflow-hidden">
          <DialogHeader>
            <DialogTitle>{s("logout")}</DialogTitle>
          </DialogHeader>
          <DialogDescription className="text-sm text-gray-950 lg:text-xl text-center font-bold">
            {s("logout-alert")}
          </DialogDescription>
          <DialogFooter className="flex flex-row justify-center mx-auto items-center gap-6">
            <Button
              className="w-32"
              type="button"
              onClick={() => {
                startTransition(async () => {
                  const { error, message } = await logout();
                  if (error) {
                    toastError(message);
                  } else {
                    toastSuccess(message);
                    localStorage.removeItem("wishlist-storage");
                    setShowModal(false);
                    location.href = "/";
                  }
                });
              }}
            >
              {isPending ? <Loader2 className="animate-spin" /> : s("yes")}
            </Button>
            <DialogClose asChild>
              <Button className="w-32" type="button" variant="secondary">
                {s("no")}
              </Button>
            </DialogClose>
          </DialogFooter>
        </DialogContent>
      </Dialog>
    </section>
  );
}
