'use client'
import {
    Table, TableBody, TableCell, TableHead, TableHeader, TableRow
} from "@/components/ui/table";
import { CiCalendar } from 'react-icons/ci';
import BlackBtn from "../../shared/BlackBtn";
import PopUpForm from "../../shared/PopUpForm";
import CreditCharge from "../CreditCharge/CreditCharge";
import React, { useState } from 'react';
import { useTranslations } from "next-intl";
import AlertWarning from "../../shared/AlertWarning";
import { useCurrency } from "@/stores/currency-state";

export default function Credit({ data, nodata }) {
    const [showModal, setShowModal] = useState(false);
    const t = useTranslations('user')
    const formatDate = (dateString) => new Date(dateString).toLocaleString();
    const { currencyShortname, rate } = useCurrency()

    return (
        <section>
            <div>
                <div className="flex flex-wrap gap-2 xl:gap-10 justify-center">
                    <div className="bg-white max-xl:w-[45%] py-7 rounded-sm lg:px-10 xl:px-20">
                        <div className="flex flex-col items-center gap-2 justify-center">
                            <h4 className='font-bold text-2xl'>{data?.user_points || 0}</h4>
                            <h4>{t('points')}</h4>
                        </div>
                    </div>
                    <div className="bg-[#EBF9FF] max-xl:w-[45%] py-7 rounded-sm lg:px-10 xl:px-20">
                        <div className="flex flex-col items-center gap-2 justify-center">
                            <h4 className='font-bold space-x-2 text-2xl'>{
                                parseFloat((data?.total) * rate)?.toFixed(2) || "0"}
                                <span className='font-light mx-1'>{currencyShortname}</span></h4>
                            <h4>{t('balance')}</h4>
                        </div>
                    </div>
                    <BlackBtn onclick={() => setShowModal(true)} title={t('rechargebalance')} className={'self-end'} />
                </div>
                {/* START THE TABLE */}
                {nodata ? <AlertWarning text={nodata || "no data"} /> :
                    <div className="my-10 overflow-x-auto">
                        <Table>
                            <TableHeader className="bg-light py-4 md:py-6 text-white">
                                <TableRow className="font-extrabold">
                                    <TableHead className="font-extrabold text-base md:text-xl text-center text-black">#</TableHead>
                                    <TableHead className="font-extrabold text-base md:text-xl text-center max-md:hidden text-black">{t('date')} </TableHead>
                                    <TableHead className="font-extrabold text-base md:text-xl text-center text-black">{t('amount')} </TableHead>
                                    <TableHead className="font-extrabold text-base md:text-xl text-center text-black">{t('type')} </TableHead>
                                    <TableHead className="font-extrabold text-base md:text-xl text-center text-black">{t('status')} </TableHead>
                                </TableRow>
                            </TableHeader>
                            <TableBody>
                                {data?.transactions?.map((item, index) => (
                                    <TableRow key={item.id} className="text-base md:text-lg shadow-md">
                                        <TableCell className="py-2 md:py-4 text-center">{index + 1}</TableCell>
                                        <TableCell className="py-2 md:py-4 text-center justify-center h-[50px] lg:h-[100px] gap-2 flex items-center max-md:hidden">
                                            <div><CiCalendar /></div>
                                            <h4>{formatDate(item.created_at)}</h4>
                                        </TableCell>
                                        <TableCell className="py-2 md:py-4 text-center">
                                            <span>{currencyShortname}</span>
                                            <span className="font-extrabold mx-2">
                                                {parseFloat((item.total) * rate).toFixed(2)}
                                            </span>
                                        </TableCell>
                                        <TableCell className="py-2 md:py-4 text-center">
                                            {item.type ? <button className="bg-black  p-1 md:p-2 rounded-sm text-sm md:text-md text-white" style={{ cursor: "default" }}>{item.type} </button> : ""}
                                        </TableCell>
                                        <TableCell className="py-2 md:py-4 text-center">
                                            <h4 className="bg-[#FFFCE7] w-fit px-2 py-1 text-sm md:text-md">{item.status}</h4>
                                        </TableCell>
                                    </TableRow>
                                ))}
                            </TableBody>
                        </Table>
                    </div>
                }
                {/* END THE TABLE */}

                {showModal && <PopUpForm showModal={showModal}
                    setShowModal={setShowModal} title={t('rechargebalance')} form={<CreditCharge setShowModal={setShowModal} />} />}
            </div>
        </section>
    )
}
