"use client";
import { useCurrency } from "@/stores/currency-state";
import { useTranslations } from "next-intl";

export default function WithdrawingLimit({ limit }) {
  const t = useTranslations("user");
  const { rate, currencyShortname } = useCurrency();
  return (
    <div className="flex items-center gap-x-2">
      <p className="lg:text-xl font-semibold">{t("limit")}</p>
      <p className="lg:text-xl font-semibold">:</p>
      <p className="lg:text-2xl font-bold text-main">
        {limit !== null ? (Number(limit) * rate).toFixed(2) : "0.00"}{" "}
        {currencyShortname}
      </p>
    </div>
  );
}
