import { getToken } from "@/actions/cookies";
import fetchData from "@/api/fetch-data";
import AlertWarning from "../../shared/AlertWarning";
import { getLocale, getTranslations } from "next-intl/server";
import {
  Table,
  TableBody,
  TableCell,
  TableHead,
  TableHeader,
  TableRow,
} from "@/components/ui/table";

export default async function WithdrawingRequests({}) {
  const locale = await getLocale();
  const t = await getTranslations("user");

  const response = await fetchData({
    endPoint: "/user/withdraw/requests",
    locale,
  });

  if (response?.status === "success") {
    const data = response?.data;

    if (!data?.withdrawal_requests || data.withdrawal_requests.length === 0) {
      return <AlertWarning text={t("noRequest")} />;
    }

    return (
      <div className="xl:my-10 overflow-x-auto">
        <Table className="min-w-full">
          <TableHeader className="bg-light py-4 md:py-6 text-white">
            <TableRow>
              <TableHead className="font-bold text-sm md:text-xl text-center text-black">
                #
              </TableHead>
              <TableHead className="font-bold text-sm md:text-xl text-center text-black">
                {t("withdrawAmount")}
              </TableHead>
              <TableHead className="font-bold text-sm md:text-xl text-center text-black">
                {t("withdrawCurrency")}
              </TableHead>
              <TableHead className="font-bold text-sm md:text-xl text-center text-black">
                {t("withdrawDetails")}
              </TableHead>
              <TableHead className="font-bold text-sm md:text-xl text-center text-black">
                {t("withdrawStatus")}
              </TableHead>
            </TableRow>
          </TableHeader>
          <TableBody>
            {data.withdrawal_requests.map((item, index) => (
              <TableRow key={item.id}>
                <TableCell className="py-2 md:py-4 font-bold md:text-xl text-sm text-center text-main">
                  {index + 1}
                </TableCell>
                <TableCell className="py-2 md:py-4 text-center font-bold md:text-xl text-sm ">
                  {item.amount}
                </TableCell>
                <TableCell className="py-2 md:py-4 text-center font-bold md:text-xl text-sm">
                  {item.currency}
                </TableCell>
                <TableCell className="py-2 md:py-4 text-center font-bold md:text-xl text-sm ">
                  <p className="line-clamp-1">
                    {`${item.details.split(" ").slice(0, 5).join(" ")}...`}
                  </p>
                </TableCell>
                <TableCell className="py-2 md:py-4 text-center font-bold md:text-xl text-sm ">
                  {item.status}
                </TableCell>
              </TableRow>
            ))}
          </TableBody>
        </Table>
      </div>
    );
  }
}
