"use client";
import {
  Dialog,
  DialogContent,
  DialogHeader,
  DialogTitle,
  DialogTrigger,
} from "@/components/ui/dialog";
import { Button } from "@/components/ui/button";
import { Plus } from "lucide-react";
import { useState } from "react";
import { useTranslations } from "next-intl";
import VendorCard from "./VendorCard/VendorCard";

export default function AddProductDialog({ categories }) {
  const [dialogOpen, setDialogOpen] = useState(false);
  const t = useTranslations("vendor");

  return (
    <Dialog open={dialogOpen} onOpenChange={setDialogOpen}>
      <DialogTrigger asChild>
        <Button className="bg-main font-bold mb-6 hover:bg-main/90">
          {t("add-product")}
          <Plus />
        </Button>
      </DialogTrigger>
      <DialogContent className="sm:max-w-[425px]">
        <DialogHeader>
          <DialogTitle>{t("new-product")}</DialogTitle>
        </DialogHeader>
        <VendorCard
          setDialogOpen={setDialogOpen}
          isSubmit={true}
          categories={categories}
        />
      </DialogContent>
    </Dialog>
  );
}
