'use client';
import { zodResolver } from '@hookform/resolvers/zod';
import { useForm } from 'react-hook-form';
import { z } from 'zod';
import { Form, FormField, FormItem, FormLabel, FormMessage } from '@/components/ui/form';
import { Input } from '@/components/ui/input';
import { useTranslations } from 'next-intl';
import SubmitButton from '../../shared/SubmitButton';
import { toastSuccess } from '@/services/custom-toast';
import { FaSpinner } from 'react-icons/fa';

export default function AddValues({ setValue }) {
    const t = useTranslations('vendor');
    const e = useTranslations('form-errors');

    const form = useForm({
        resolver: zodResolver(
            z.object({
                value: z.string().min(1, e('required')),
            })
        ),
        defaultValues: { value: '' },
    });

    async function onSubmit(data) {
        setValue({ value: data.value }); // Pass the new value to Combobox
        toastSuccess(t('addedsuccessfully'));
    }

    return (
        <Form {...form} className="bg-red-500">
            <form onSubmit={form.handleSubmit(onSubmit)} className="flex flex-codl max-md:w-full gap-2">
                <FormField
                    control={form.control}
                    name="value"
                    className="bg-red-500 w-full"
                    render={({ field }) => (
                        <FormItem className="w-64">
                            <Input placeholder={t('entervalue')} {...field} className="max-md:h-10" />
                            <FormMessage />
                        </FormItem>
                    )}
                />
                <button
                    type="submit"
                    className="w-auto md:w-28 h-10 md:h-12 btn btn-btnColor  text-white p-2 rounded-md"
                >
                    {t("send")}
                </button>
            </form>
        </Form>
    );
}
