"use client";
import deleteData from "@/api/delete-data";
import { Input } from "@/components/ui/input";
import { CircleCheckBig, Plus, X } from "lucide-react";
import { useTranslations } from "next-intl";

export default function CheckboxOption({
  inputObject,
  addDataToCheckBox,
  addNewOptionToCheckbox,
  deleteOptionFromCheckbox,
}) {
  const t = useTranslations("form_builder");
  const deleteInputHandler = async (id) => {
    await deleteData({
      endPoint: `/user/products/custom-fields/options/${id}`,
    });
  };

  return (
    <>
      {inputObject?.options?.map((option, index) => {
        return (
          <div
            className="flex items-center justify-center gap-2 w-full "
            key={option.optionId}
          >
            <Input
              required
              id={option.optionId + "valueName"}
              type="text"
              placeholder={t("field_name")}
              value={option.name}
              onChange={(e) =>
                addDataToCheckBox(inputObject.id, option.id, {
                  name: e.target.value,
                })
              }
              className="flex-1"
            />
            <Input
              required
              id={option.optionId + "value"}
              type="text"
              placeholder={t("field_description")}
              value={option.price}
              onChange={(e) =>
                addDataToCheckBox(inputObject.id, option.id, {
                  price: e.target.value,
                })
              }
              className="flex-1"
            />
            {index !== 0 ? (
              <div className="p-1 rounded-full border border-red-900 hover:cursor-pointer hover:bg-red-500 group duration-500">
                <X
                  className="text-red-500 group-hover:text-white"
                  onClick={() => {
                    deleteOptionFromCheckbox(inputObject.id, option.id);
                    deleteInputHandler(option.id);
                  }}
                />
              </div>
            ) : (
              <div className="p-1 rounded-full border border-blue-900 hover:cursor-pointer hover:bg-blue-500 group duration-500">
                <CircleCheckBig className="text-blue-500 group-hover:text-white" />
              </div>
            )}
          </div>
        );
      })}
      <div className="p-1 rounded-full border border-blue-900 hover:cursor-pointer hover:bg-blue-500 group duration-500">
        <Plus
          onClick={() => addNewOptionToCheckbox(inputObject.id)}
          className="text-blue-500 group-hover:text-white"
        />
      </div>
    </>
  );
}
