import { Label } from "@/components/ui/label";

import React from "react";

import { Checkbox } from "@/components/ui/checkbox";

export default function CustomCheckBox({ index, value, setValue }) {
  return (
    <div className="flex items-center space-x-2">
      <Checkbox
        id={`checkbox-${index}`}
        checked={value === "true"}
        onCheckedChange={(checked) => setValue(checked ? "true" : "false")}
      />
      <Label htmlFor={`checkbox-${index}`}>Checkbox {index + 1}</Label>
    </div>
  );
}
