import CustomTextInput from "./CoustomTextInput";
import CustomCheckBoxInput from "./CustomCheckboxInput";
import ReorderArrows from "./ReorderArrows";
export default function CustomInput({
  addInputData,
  inputObject,
  removeInputFormHandler,
  addOptionToInput,
  addDataToCheckBox,
  addNewOptionToCheckbox,
  deleteOptionFromCheckbox,
  reorderInputs,
  index,
  formInputs,
}) {
  const renderInput = () => {
    switch (inputObject?.inputType) {
      case "smalltext":
        return (
          <>
            <CustomTextInput
              addInputData={addInputData}
              inputObject={inputObject}
              removeInputFormHandler={removeInputFormHandler}
            />
            <ReorderArrows
              index={index}
              totalLength={formInputs.length}
              onMoveUp={() => reorderInputs(index, "up")}
              onMoveDown={() => reorderInputs(index, "down")}
            />
          </>
        );

      case "largetext":
        return (
          <>
            <CustomTextInput
              addInputData={addInputData}
              inputObject={inputObject}
              removeInputFormHandler={removeInputFormHandler}
            />
            <ReorderArrows
              index={index}
              totalLength={formInputs.length}
              onMoveUp={() => reorderInputs(index, "up")}
              onMoveDown={() => reorderInputs(index, "down")}
            />
          </>
        );

      case "number":
        return (
          <>
            <CustomTextInput
              addInputData={addInputData}
              inputObject={inputObject}
              removeInputFormHandler={removeInputFormHandler}
            />
            <ReorderArrows
              index={index}
              totalLength={formInputs.length}
              onMoveUp={() => reorderInputs(index, "up")}
              onMoveDown={() => reorderInputs(index, "down")}
            />
          </>
        );

      case "checkbox":
        return (
          <>
            <CustomCheckBoxInput
              addDataToCheckBox={addDataToCheckBox}
              addInputData={addInputData}
              addOptionToInput={addOptionToInput}
              inputObject={inputObject}
              removeInputFormHandler={removeInputFormHandler}
              addNewOptionToCheckbox={addNewOptionToCheckbox}
              deleteOptionFromCheckbox={deleteOptionFromCheckbox}
            />
            <ReorderArrows
              index={index}
              totalLength={formInputs.length}
              onMoveUp={() => reorderInputs(index, "up")}
              onMoveDown={() => reorderInputs(index, "down")}
            />
          </>
        );

      case "radio":
        return (
          <>
            <CustomCheckBoxInput
              addDataToCheckBox={addDataToCheckBox}
              addInputData={addInputData}
              addOptionToInput={addOptionToInput}
              inputObject={inputObject}
              removeInputFormHandler={removeInputFormHandler}
              addNewOptionToCheckbox={addNewOptionToCheckbox}
              deleteOptionFromCheckbox={deleteOptionFromCheckbox}
            />
            <ReorderArrows
              index={index}
              totalLength={formInputs.length}
              onMoveUp={() => reorderInputs(index, "up")}
              onMoveDown={() => reorderInputs(index, "down")}
            />
          </>
        );

      case "image":
        return (
          <>
            <CustomTextInput
              addInputData={addInputData}
              inputObject={inputObject}
              removeInputFormHandler={removeInputFormHandler}
            />
            <ReorderArrows
              index={index}
              totalLength={formInputs.length}
              onMoveUp={() => reorderInputs(index, "up")}
              onMoveDown={() => reorderInputs(index, "down")}
            />
          </>
        );

      case "date":
        return (
          <>
            <CustomTextInput
              addInputData={addInputData}
              inputObject={inputObject}
              removeInputFormHandler={removeInputFormHandler}
            />
            <ReorderArrows
              index={index}
              totalLength={formInputs.length}
              onMoveUp={() => reorderInputs(index, "up")}
              onMoveDown={() => reorderInputs(index, "down")}
            />
          </>
        );

      case "time":
        return (
          <>
            <CustomTextInput
              addInputData={addInputData}
              inputObject={inputObject}
              removeInputFormHandler={removeInputFormHandler}
            />
            <ReorderArrows
              index={index}
              totalLength={formInputs.length}
              onMoveUp={() => reorderInputs(index, "up")}
              onMoveDown={() => reorderInputs(index, "down")}
            />
          </>
        );

      case "datetime":
        return (
          <>
            <CustomTextInput
              addInputData={addInputData}
              inputObject={inputObject}
              removeInputFormHandler={removeInputFormHandler}
            />
            <ReorderArrows
              index={index}
              totalLength={formInputs.length}
              onMoveUp={() => reorderInputs(index, "up")}
              onMoveDown={() => reorderInputs(index, "down")}
            />
          </>
        );
      default:
        return null;
    }
  };

  return (
    <div className="mb-4 p-2 border rounded w-full max-w-5xl ">
      <div className="w-full">{renderInput()}</div>
    </div>
  );
}
