import React from "react";

import { Label } from "@/components/ui/label";
import { RadioGroup, RadioGroupItem } from "@/components/ui/radio-group";
export default function CustomRadioButton({ index, value, setValue }) {
  return (
    <div className="flex flex-col space-y-2">
      <Label>Radio Group {index + 1}</Label>
      <RadioGroup value={value} onValueChange={setValue}>
        <div className="flex items-center space-x-2">
          <RadioGroupItem value="option1" id={`radio1-${index}`} />
          <Label htmlFor={`radio1-${index}`}>Option 1</Label>
        </div>
        <div className="flex items-center space-x-2">
          <RadioGroupItem value="option2" id={`radio2-${index}`} />
          <Label htmlFor={`radio2-${index}`}>Option 2</Label>
        </div>
      </RadioGroup>
    </div>
  );
}
