"use client";
import deleteData from "@/api/delete-data";
import { Button } from "@/components/ui/button";
import { Input } from "@/components/ui/input";
import { toast } from "@/hooks/use-toast";
import { useTranslations } from "next-intl";
import { useState } from "react";
import RequiredCheckbox from "./RequiredCheckbox";

export default function CustomTextInput({
  inputObject,
  addInputData,
  removeInputFormHandler,
}) {
  const [hasSubmitted, setHasSubmitted] = useState(false);
  const t = useTranslations("form_builder");
  const toggleHasSubmitted = () => {
    if (!inputObject?.placeHolder || !inputObject?.fieldName) {
      return toast({
        title: "You need to add both placeholder and field name",
        variant: "destructive",
      });
    }
    setHasSubmitted((c) => !c);
  };

  const deleteInputHandler = async (inputId) => {
    removeInputFormHandler(inputId);

    await deleteData({
      endPoint: `/user/products/custom-fields/${inputId}`,
      pathToRevalidate: "/",
    });
  };

  return (
    <div className="flex flex-col space-y-2 p-2">
      <div className="">
        <h2 className="my-2">{t("input_text_heading")}</h2>
        {hasSubmitted ? (
          <div className="flex flex-col gap-4">
            <p>{`${t("field_name")} :${inputObject.fieldName} `}</p>
            <p>{`${t("field_description")} :${inputObject.placeHolder} `}</p>
            <p>{`${t("need_to_enterd")} :${
              inputObject.isRequired ? t("yes") : t("no")
            } `}</p>
          </div>
        ) : (
          <div className="flex flex-col gap-4 p-2 items-center">
            <Input
              required
              id={inputObject.id}
              type="text"
              placeholder={t("field_name")}
              value={inputObject?.fieldName}
              onChange={(e) => {
                addInputData(inputObject.id, { fieldName: e.target.value });
              }}
            />
            <Input
              required
              id={inputObject.id}
              type="text"
              placeholder={t("field_description")}
              value={inputObject?.placeHolder}
              onChange={(e) => {
                addInputData(inputObject.id, { placeHolder: e.target.value });
              }}
            />
            <RequiredCheckbox
              inputObject={inputObject}
              addInputData={addInputData}
            />
          </div>
        )}
        <div className="flex justify-between my-2">
          <Button
            variant="outline"
            onClick={() => deleteInputHandler(inputObject.id)}
          >
            {t("delete")}
          </Button>
          {/* {!hasSubmitted && (
            <Button onClick={toggleHasSubmitted}>{t("confirm")}</Button>
          )} */}
        </div>
      </div>
    </div>
  );
}
