"use client";
import { Button } from "@/components/ui/button";
import {
  Card,
  CardContent,
  CardFooter,
  CardHeader,
  CardTitle,
} from "@/components/ui/card";
import { Input } from "@/components/ui/input";
import { toast } from "@/hooks/use-toast";
import { useState } from "react";
import CheckboxOption from "./CheckboxOption";
import RequiredCheckbox from "./RequiredCheckbox";
import { useTranslations } from "next-intl";
import deleteData from "@/api/delete-data";

export default function CustomCheckBoxInput({
  inputObject,
  addInputData,
  removeInputFormHandler,
  addDataToCheckBox,
  addNewOptionToCheckbox,
  deleteOptionFromCheckbox,
}) {
  const t = useTranslations("form_builder");
  const [isDeleting, setIsDeleting] = useState(false);
  const [hasSubmitted, setHasSubmitted] = useState(false);

  const toggleHasSubmitted = () => {
    // Check if field name or placeholder is empty
    if (!inputObject?.placeHolder || !inputObject?.fieldName) {
      return toast({
        title: t("field_description_error_message"),
        variant: "destructive",
      });
    }

    // Check if inputType is checkbox and validate all options
    if (inputObject.inputType === "checkbox") {
      // Check if all options have both valueName and value
      const allOptionsValid = inputObject.options.every(
        (option) => option.valueName.trim() !== "" && option.value.trim() !== ""
      );

      if (!allOptionsValid) {
        return toast({
          title: t("enterd_field_name_and_description"),
          variant: "destructive",
        });
      }
    }

    // If all validations pass, toggle hasSubmitted
    setHasSubmitted((c) => !c);
  };

  const deleteInputHandler = async (inputId) => {
    removeInputFormHandler(inputId);

    setIsDeleting(true);
    await deleteData({
      endPoint: `/user/products/custom-fields/${inputId}`,
      pathToRevalidate: "/",
    });
    setIsDeleting(false);
  };

  return (
    <div className="flex flex-col space-y-2 w-full">
      <div className="">
        <h2>{t("checkbox_text_heading")}</h2>
        {hasSubmitted ? (
          <div className="flex flex-col gap-2">
            <p>{`${t("field_name")} :${inputObject.fieldName} `}</p>
            <p>{`${t("field_description")} :${inputObject.placeHolder} `}</p>
            <p>{`${t("need_to_enterd")} :${
              inputObject.isRequired ? t("yes") : t("no")
            } `}</p>
          </div>
        ) : (
          <div className="flex flex-col gap-2 p-2 items-center">
            <Input
              id={inputObject.id}
              type="text"
              placeholder={t("field_name")}
              value={inputObject?.fieldName}
              onChange={(e) => {
                addInputData(inputObject.id, { fieldName: e.target.value });
              }}
            />
            <Input
              id={inputObject.id}
              type="text"
              placeholder={t("field_description")}
              value={inputObject?.placeholder}
              onChange={(e) => {
                addInputData(inputObject.id, { placeHolder: e.target.value });
              }}
            />

            <RequiredCheckbox
              inputObject={inputObject}
              addInputData={addInputData}
            />

            {(inputObject.inputType === "checkbox" ||
              inputObject.inputType === "radio") && (
              <CheckboxOption
                deleteOptionFromCheckbox={deleteOptionFromCheckbox}
                addNewOptionToCheckbox={addNewOptionToCheckbox}
                inputObject={inputObject}
                addDataToCheckBox={addDataToCheckBox}
              />
            )}
          </div>
        )}
        <div className="flex justify-between my-2">
          <Button
            variant="outline"
            disabled={isDeleting}
            onClick={() => deleteInputHandler(inputObject.id)}
          >
            {isDeleting ? t("deleting") : t("delete")}
          </Button>
          {/* {!hasSubmitted && (
            <Button onClick={toggleHasSubmitted}> {t("confirm")}</Button>
          )} */}
        </div>
      </div>
    </div>
  );
}
