import { ArrowUp, ArrowDown } from "lucide-react";

export default function ReorderArrows({
  onMoveUp,
  onMoveDown,
  index,
  totalLength,
}) {
  return (
    <div className="flex flex-col">
      {index > 0 && (
        <ArrowUp
          onClick={onMoveUp}
          className="text-blue-500 hover:cursor-pointer hover:text-blue-700"
        />
      )}
      {index < totalLength - 1 && (
        <ArrowDown
          onClick={onMoveDown}
          className="text-blue-500 hover:cursor-pointer hover:text-blue-700"
        />
      )}
    </div>
  );
}
