"use client";

import { Checkbox } from "@/components/ui/checkbox";
import { useTranslations } from "next-intl";

export default function RequiredCheckbox({ inputObject, addInputData }) {
  const t = useTranslations("form_builder");

  const handleRequiredChange = (checked) => {
    if (checked) {
      addInputData(inputObject.id, { isRequired: checked });
    } else if (!checked && inputObject?.isRequired) {
      delete inputObject?.isRequired;
    } else {
    }
  };
  return (
    <div className="flex items-center space-x-2 self-start ml-2 my-2">
      <Checkbox
        id={`required-${inputObject.id}`}
        checked={!!inputObject?.isRequired}
        onCheckedChange={handleRequiredChange}
        className="mx-2"
      />
      <label
        htmlFor={`required-${inputObject.id}`}
        className="text-sm font-medium leading-none peer-disabled:cursor-not-allowed peer-disabled:opacity-70 mx-2"
      >
        {t("is_required")}
      </label>
    </div>
  );
}
