import {
  DropdownMenu,
  DropdownMenuContent,
  DropdownMenuItem,
  DropdownMenuLabel,
  DropdownMenuSeparator,
  DropdownMenuTrigger,
} from "@/components/ui/dropdown-menu";
import { Button } from "@/components/ui/button";
import { useLocale, useTranslations } from "next-intl";
import { Plus } from "lucide-react";

export default function InputTypeDropdown({ onAddInputFormHandler }) {
  const t = useTranslations("form_builder");
  const l = useLocale();
  const inputOptions = [
    { type: "smalltext", text: t("small_input") },
    { type: "largetext", text: t("large_input") },
    { type: "number", text: t("number_input") },
    { type: "checkbox", text: t("checkbox_input") },
    { type: "radio", text: t("radio_input") },
    { type: "image", text: t("image_input") },
    { type: "date", text: t("date_input") },
    { type: "time", text: t("time_input") },
    { type: "datetime", text: t("datetime_input") },
  ];
  const dir = l === "en" ? "ltr" : "rlt";
  return (
    <div className="w-fit">
      <DropdownMenu dir={dir}>
        <DropdownMenuTrigger asChild dir={dir}>
          <Button
            variant="outline"
            className="flex gap-2 duration-500 text-main border border-main font-bold text-xl group"
          >
            <Plus className="text-main duration-500 group-hover:text-white" />

            {t("addField")}
          </Button>
        </DropdownMenuTrigger>
        <DropdownMenuContent dir={dir}>
          <DropdownMenuLabel dir={dir}>
            {t("choose_field_type")}
          </DropdownMenuLabel>
          <DropdownMenuSeparator />
          {inputOptions.map((option) => (
            <DropdownMenuItem
              dir={dir}
              key={option.type}
              onSelect={() => {
                onAddInputFormHandler(option.type);
              }}
            >
              {option.text}
            </DropdownMenuItem>
          ))}
        </DropdownMenuContent>
      </DropdownMenu>
    </div>
  );
}
