"use client";
import postData from "@/api/post-data";
import SubmitButton from "@/app/ui/shared/SubmitButton";
import {
  Form,
  FormControl,
  FormField,
  FormItem,
  FormMessage,
} from "@/components/ui/form";
import { Input } from "@/components/ui/input";
import { toastError, toastSuccess } from "@/services/custom-toast";
import { zodResolver } from "@hookform/resolvers/zod";
import { useLocale, useTranslations } from "next-intl";
import { useForm } from "react-hook-form";
import { z } from "zod";

export default function ProductMetaTags({ productId }) {
  const t = useTranslations("vendor");

  const form = useForm({
    resolver: zodResolver(
      z.object({
        title: z.string({ message: t("no_title") }).min(1, t("no_title")),
        description: z
          .string({ message: t("no_description") })
          .min(1, t("no_description")),
        keyword: z
          .string({ message: t("no_keywords") })
          .min(1, t("no_keywords")),
      })
    ),
  });

  const {
    reset,
    formState: { isSubmitting },
  } = form;

  async function onSubmit(values) {
    const formData = new FormData();

    // Correctly append nested values using square bracket notation
    formData.append("id", productId);
    formData.append("value[title]", values.title);
    formData.append("value[description]", values.description);
    formData.append("value[keyword]", values.keyword);

    const { error, message, data } = await postData({
      endPoint: "/user/products/meta",
      body: formData,
    });

    if (error) {
      return toastError(message);
    }

    reset();
    toastSuccess(message);
  }
  return (
    <section className="max-md:mx-4 mt-12 mb-20 rounded-lg  py-4 max-w-5xl flex flex-col gap-4">
      {/* <div className="space-y-2 mb-12">
              <h1 className="font-bold text-xl text-center md:text-2xl lg:text-3xl text-dark mb-12">{t('title')}</h1>
          </div> */}
      <Form {...form}>
        <form
          method="post"
          onSubmit={form.handleSubmit(onSubmit)}
          className="flex flex-col gap-4"
        >
          {/* Title Field */}
          <FormField
            name="title"
            control={form.control}
            render={({ field }) => (
              <FormItem>
                <FormControl>
                  <Input
                    {...field}
                    type="text"
                    placeholder={t("product_title")}
                  />
                </FormControl>
                <FormMessage />
              </FormItem>
            )}
          />

          {/* Description Field */}
          <FormField
            name="description"
            control={form.control}
            render={({ field }) => (
              <FormItem>
                <FormControl>
                  <Input
                    {...field}
                    type="text"
                    placeholder={t("product_description")}
                  />
                </FormControl>
                <FormMessage />
              </FormItem>
            )}
          />

          {/* Keyword Field */}
          <FormField
            name="keyword"
            control={form.control}
            render={({ field }) => (
              <FormItem>
                <FormControl>
                  <Input
                    {...field}
                    type="text"
                    placeholder={t("product_keywords")}
                  />
                </FormControl>
                <FormMessage />
              </FormItem>
            )}
          />

          {/* Submit button */}
          <SubmitButton
            className="w-28"
            isIcon={false}
            text={t("save")}
            loading={isSubmitting}
          />
        </form>
      </Form>
    </section>
  );
}
