import fetchData from "@/api/fetch-data";
import AlertWarning from "@/app/ui/shared/AlertWarning";
import { Tabs, TabsContent, TabsList, TabsTrigger } from "@/components/ui/tabs";
import { getLocale, getTranslations } from "next-intl/server";
import Color from "./Color";
import Size from "./Size";

export default async function ProductFeatures({ productId }) {
  const locale = await getLocale();
  const t = await getTranslations("vendor");
  const { error, data, message } = await fetchData({
    endPoint: `/user/products/features/${productId}`,
    locale,
  });

  if (error) return <AlertWarning text={message} />;
  const colors = data?.filter((f) => f.type == "color");
  const sizes = data?.filter((f) => f.type == "size");

  return (
    <section>
      <div className="container">
        <Tabs
          defaultValue="colors"
          className="w-full"
          dir={locale == "en" ? "ltr" : "rtl"}
        >
          <TabsList className="px-0 pb-5 my-5  bg-transparent border-b-[3px] gap-4 lg:gap-10  border-[#F4F4F4] rounded-none flex duration-100 transition-all w-full justify-start">
            <TabsTrigger
              value="colors"
              className=" px-0 text-base text-[#9DA0A1] data-[state=active]:rounded-none  pb-6 data-[state=active]:border-b-[3px] duration-100 transition-all font-extrabold data-[state=active]:border-main data-[state=active]:bg-transparent data-[state=active]:shadow-none "
            >
              {t("colors")}
            </TabsTrigger>
            <TabsTrigger
              value="sizes"
              className=" px-0 text-base text-[#9DA0A1] data-[state=active]:rounded-none  pb-6 data-[state=active]:border-b-[3px] duration-100 transition-all font-extrabold data-[state=active]:border-main data-[state=active]:bg-transparent data-[state=active]:shadow-none "
            >
              {t("sizes")}
            </TabsTrigger>
          </TabsList>
          <TabsContent value="colors">
            <Color productId={productId} />
            {colors?.map((item, i) => (
              <div key={i}>
                <Color data={item} productId={productId} />
              </div>
            ))}
          </TabsContent>
          <TabsContent value="sizes">
            <Size productId={productId} />
            {sizes?.map((item, i) => (
              <div key={i}>
                <Size data={item} productId={productId} />
              </div>
            ))}
          </TabsContent>
        </Tabs>
      </div>
    </section>
  );
}
