"use client";
import {
  Select,
  SelectContent,
  SelectGroup,
  SelectItem,
  SelectLabel,
  SelectTrigger,
  SelectValue,
} from "@/components/ui/select";
import { useState } from "react";

const selectOptions = ["Text", "Number", "Checkbox", "RadioButton"];
export default function SelectFormInput({ setFormList, formList }) {
  const addNewFormInput = (value) => {
    setFormList(value);
  };

  return (
    <Select onValueChange={addNewFormInput}>
      <SelectTrigger className="w-[180px]">
        <SelectValue placeholder="Select a fruit" />
      </SelectTrigger>
      <SelectContent>
        <SelectGroup>
          <SelectLabel>Add form</SelectLabel>
          {selectOptions.map((option) => (
            <SelectItem key={option} value={option}>
              {option}
            </SelectItem>
          ))}
        </SelectGroup>
      </SelectContent>
    </Select>
  );
}
