import fetchData from "@/api/fetch-data";
import { Table, TableHead, TableHeader, TableRow } from "@/components/ui/table";
import { getLocale, getTranslations } from "next-intl/server";
import AlertWarning from "../shared/AlertWarning";
import ProductLabelsBody from "./ProductLabelsBody";

export default async function TranslateProductLabels({ id }) {
   const t = await getTranslations('vendor');
   const locale = await getLocale();
   const { data, error } = await fetchData({
      endPoint: `/user/products/addtional-details/translation/${id}`,
      locale,
   });
   if (error) return;
   const labels = data?.types;
   if (labels?.length < 1) return <AlertWarning text={t('no-labels')} />

   return (
      <Table>
         <TableHeader>
            <TableRow>
               <TableHead className="w-[100px]">#</TableHead>
               <TableHead>{t('property')}</TableHead>
               <TableHead>{t('property-translate')}</TableHead>
               <TableHead>{t('value')}</TableHead>
               <TableHead>{t('value-translate')}</TableHead>
            </TableRow>
         </TableHeader>
         <ProductLabelsBody labels={labels} locale={locale} />
      </Table>
   );
}