import { useTranslations } from "next-intl";
import React from "react";

export default function ProductState({ children, item }) {
  const t = useTranslations("vendor");
  return (
    <div
      key={item?.id}
      className={`${item?.hidden == "1" ? "opacity-60 relative " : ""} `}
    >
      <div
        className={`${
          item.hidden == "1"
            ? "absolute bg-yellow-800  text-center text-xl left-1/2 -translate-x-1/2  text-white px-4 py-2 top-[15%] rounded-xl "
            : " hidden"
        } `}
      >
        <p className="">{t("product-hidden")}</p>
      </div>
      {children}
    </div>
  );
}
