"use client";
import getUserProfile from "@/api/user/getUserProfile";
import { useSuspenseQuery } from "@tanstack/react-query";
import { useLocale, useTranslations } from "next-intl";
import AuctionClientList from "../home/AuctionClientList";
import UpdateAuctionsPricesButton from "../home/UpdateAuctionsPricesButton";
import fetchData from "@/api/fetch-data";

export default function AuctionClientPage({ currentPage }) {
  const locale = useLocale();
  const t = useTranslations("navbar");

  const { refetch, isLoading, isFetching, data } = useSuspenseQuery({
    queryKey: [`/auctions?page=${currentPage}`, locale],
    queryFn: () => fetchData({ endPoint: `/auctions?page=${currentPage}` }),
  });

  const { data: profile } = useSuspenseQuery({
    queryKey: ["/user/get/profile"],
    queryFn: () => getUserProfile(),
  });

  const auctions = data?.data?.auctions || [];
  const totalNumberOfPages = data?.data?.meta?.last_page || 1;

  return (
    <div>
      <div className="flex justify-between items-center">
        <h1 className="font-bold md:text-4xl text-xl text-main my-6">
          {t("auctions")}
        </h1>
        <UpdateAuctionsPricesButton
          currentPage={currentPage}
          refetch={refetch}
          isLoading={isLoading}
          isFetching={isFetching}
        />
      </div>
      <div className="min-h-[1090px]">
        <AuctionClientList
          profile={profile}
          isSinglePage={true}
          currentPage={currentPage}
          totalNumberOfPages={totalNumberOfPages}
          auctions={auctions}
        />
      </div>
    </div>
  );
}
