'use client';
import { Checkbox } from "@/components/ui/checkbox";
import { Form, FormControl, FormField, FormItem, FormMessage } from "@/components/ui/form";
import { Input } from "@/components/ui/input";
import { Select, SelectContent, SelectItem, SelectTrigger, SelectValue } from "@/components/ui/select";
import { zodResolver } from "@hookform/resolvers/zod";
import { useLocale, useTranslations } from "next-intl";
import { useForm } from "react-hook-form";
import { z } from "zod";
import CountrySelect from "../shared/CountrySelect";



export default function ShippingAddress() {
   const error = useTranslations("form-errors");
   const label = useTranslations("form-labels");
   const t = useTranslations("checkout-info");
   const locale = useLocale();

   const form = useForm({
      resolver: zodResolver(
         z.object({
            country: z.string({ errorMap: () => ({ message: error("required") }) }).min(1),
            city: z.string({ errorMap: () => ({ message: error("required") }) }).min(1),
            area: z.string({ errorMap: () => ({ message: error("required") }) }).min(1),
            street: z.string({ errorMap: () => ({ message: error("required") }) }).min(1),
            neighborhood: z.string({ errorMap: () => ({ message: error("required") }) }).min(1),
            address: z.string({ message: error("required") }).min(3, { message: error("at-least3") }),
         })),
   });
   return (
      <section>
         {/* Text */}
         <div className="mb-8">
            <h1 className="text-xl mb-6 font-bold">
               {t('shipping-address')}
            </h1>
            <div className="flex items-center gap-3 border border-dark p-6">
               <Checkbox id="same-address"
                  className="size-5"
               />
               <label
                  htmlFor="same-address"
                  className="text-base text-dark"
               >
                  {t('same-address')}
               </label>
            </div>
            <div className="flex items-center gap-3 border border-dark p-6">
               <Checkbox
                  id="another-address"
                  className="size-5"
               />
               <label
                  htmlFor="another-address"
                  className="text-sm font-medium leading-none peer-disabled:cursor-not-allowed peer-disabled:opacity-70"
               >
                  {t('another-address')}
               </label>
            </div>
         </div>
         {true && <Form {...form}>
            <form className="space-y-4 md:bg-white md:p-2">
               <FormField
                  name="country"
                  control={form.control}
                  render={({ field }) => (
                     <FormItem>
                        <FormControl>
                           <CountrySelect
                              value={field.value}
                              onChange={field.onChange}
                              placeholder={label('country')}
                           />
                        </FormControl>
                        <FormMessage />
                     </FormItem>
                  )}
               />
               <FormField
                  name="city"
                  control={form.control}
                  render={({ field }) => (
                     <FormItem>
                        <FormControl>
                           <Select
                              dir={locale === 'ar' ? 'rtl' : 'ltr'}
                              value={field.value}
                              onValueChange={field.onChange}>
                              <SelectTrigger className="focus-visible:ring-dark border-dark">
                                 <SelectValue placeholder={label("city")} />
                              </SelectTrigger>
                              <SelectContent>
                                 <SelectItem value="Cairo">Cairo</SelectItem>
                                 <SelectItem value="Alex">Alex</SelectItem>
                              </SelectContent>
                           </Select>
                        </FormControl>
                        <FormMessage />
                     </FormItem>
                  )}
               />
               <div className="flex gap-4 max-md:flex-col">
                  <FormField
                     name="area"
                     control={form.control}
                     render={({ field }) => (
                        <FormItem>
                           <FormControl>
                              <Input
                                 className="focus-visible:ring-dark border-dark"
                                 {...field}
                                 placeholder={label("area")}
                              />
                           </FormControl>
                           <FormMessage />
                        </FormItem>
                     )}
                  />
                  <FormField
                     name="street"
                     control={form.control}
                     render={({ field }) => (
                        <FormItem>
                           <FormControl>
                              <Input
                                 className="focus-visible:ring-dark border-dark"
                                 {...field}
                                 placeholder={label("street")}
                              />
                           </FormControl>
                           <FormMessage />
                        </FormItem>
                     )}
                  />
                  <FormField
                     name="neighborhood"
                     control={form.control}
                     render={({ field }) => (
                        <FormItem>
                           <FormControl>
                              <Input
                                 className="focus-visible:ring-dark border-dark"
                                 {...field}
                                 placeholder={label("neighborhood")}
                              />
                           </FormControl>
                           <FormMessage />
                        </FormItem>
                     )}
                  />
               </div>
               <FormField
                  name="address"
                  control={form.control}
                  render={({ field }) => (
                     <FormItem>
                        <FormControl>
                           <Input
                              className="focus-visible:ring-dark border-dark"
                              {...field}
                              placeholder={label("address")}
                           />
                        </FormControl>
                        <FormMessage />
                     </FormItem>
                  )}
               />
            </form>
         </Form>}
      </section>
   );
}