import { Input } from "@/components/ui/input";
import { useState } from "react";
import { IoEyeOffOutline, IoEyeOutline } from "react-icons/io5";

/**
 * @author Ahmed Badran
 * @createdAt 21-10-2024
 * PasswordInput is a component that renders an input field with a password
 * type, and a button to toggle the visibility of the password.
 *
 * @param {Object} field - The field object from the useForm hook.
 * @param {string} placeholder - The placeholder text for the input field.
 *
 * @returns {JSX.Element} - A JSX element representing the PasswordInput
 * component.
 */
export default function PasswordInput({ field, placeholder }) {
   const [displayPassword, setDisplayPassword] = useState(false);

   return (
      <div className="relative">
         <Input
            type={displayPassword ? "text" : "password"}
            className="h-8 md:h-10 lg:h-12 focus-visible:ring-main"
            placeholder={placeholder}
            {...field} />
         {
            displayPassword
               ? <IoEyeOffOutline size={24} className="text-gray-400 absolute top-1/2 end-3 -translate-y-1/2 cursor-pointer" onClick={() => setDisplayPassword(!displayPassword)} />
               : <IoEyeOutline size={24} className="text-gray-400 absolute top-1/2 end-3 -translate-y-1/2 cursor-pointer" onClick={() => setDisplayPassword(!displayPassword)} />
         }
      </div>
   );
}