"use client";
import { cn } from "@/lib/utils";
import { useQuery } from "@tanstack/react-query";
import AuctionCard from "../Pigeon/AuctionCard";
import CustomPagination from "../Pigeon/CustomPagination";
import { default as LoadingUI } from "../shared/Loading";

export default function AuctionClientList({
  isSinglePage = false,
  auctions = [],
  totalNumberOfPages = 1,
  isLoading,
  profile,
}) {
  return (
    <>
      {isLoading && isSinglePage ? (
        <LoadingUI />
      ) : (
        <>
          <section
            className={cn(
              isSinglePage
                ? "grid sm:grid-cols-2 lg:grid-cols-3 2xl:grid-cols-4 gap-4 "
                : "grid sm:grid-cols-2 lg:grid-cols-1 gap-4 mt-4 "
            )}
          >
            {Array.isArray(auctions) &&
              auctions?.map((item) => (
                <AuctionCard auction={item} profile={profile} key={item.id} />
              ))}
          </section>
          {isSinglePage && (
            <div className="mt-12 my-10">
              <CustomPagination totalNumberOfPages={totalNumberOfPages} />
            </div>
          )}
        </>
      )}
    </>
  );
}
