import { products } from "@/api/products";
import ProductCard from "../shared/ProductCard";
import SectionHeader from "../shared/SectionHeader";
import LatestProducts from "./LatestProducts";
import SideBanner from "./SideBanner";
import { useTranslations } from "next-intl";

const BestSeller = () => {
  const t = useTranslations("home");

  return (
    <div className="container">
      <div className="grid grid-cols-12 gap-6">
        <div className="lg:col-span-8 col-span-12 space-y-6">
          <SectionHeader title={t('more')} marker={t('sales')} />
          <div className="grid grid-cols-12 gap-6">
            {products.map((item) => (
              <div key={item.id} className="3xl:col-span-4 md:col-span-6 col-span-12">
                <ProductCard product={item} />
              </div>
            ))}
          </div>
        </div>
        <div className="lg:col-span-4 col-span-12 space-y-6 h-full ">
          <SideBanner />
          {/* latest products */}
          <div className="space-y-6">
            <h2 className="text-2xl">
              <span className="text-main font-semibold">{t('latest')}</span> {t('products')}
            </h2>
            <LatestProducts />
          </div>
        </div>
      </div>
    </div>
  );
};

export default BestSeller;
